/**
 * Project Name:media-api File Name:RemoteMediaAppConfigService.java Package
 * Name:cn.com.duiba.tuia.media.api.remoteservice Date:2016年10月8日下午2:56:34 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Map;

/**
 * ClassName:RemoteMediaAppConfigService <br/>
 * Function: tuia媒体app配置信息. <br/>
 * Date: 2016年10月8日 下午2:56:34 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@AdvancedFeignClient
public interface RemoteMediaAppConfigBackendService {

    /**
     * 
     * getMediaAppConfigByPage:(媒体配置信息分页). <br/>
     *
     * @author ZFZ
     * @param req
     * @return
     * @since JDK 1.6
     */
    DubboResult<PageResultDto<RspMediaAppConfigDto>> getMediaAppConfigByPage(ReqGetMediaAppConfigByPageDto req);


    DubboResult<Map<Long, MediaManagerDto>> getMediaAppManagerList(ReqGetMediaAppConfigByPageDto req);

    /**
     *
     * getMediaTage:(获取媒体校验标签). <br/>
     *
     * @author cuiwx
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DubboResult<String> getMediaTagCheck(Long appId);
    /**
     * 
     * getMediaAppConfig:(查看媒体配置信息). <br/>
     *
     * @author ZFZ
     * @param mediaAppId
     * @return
     * @since JDK 1.6
     */
    DubboResult<MediaAppConfigDto> getMediaAppConfig(Long mediaAppId);

    /**
     * 
     * updateMediaAppConfig:(修改媒体配置信息). <br/>
     *
     * @author ZFZ
     * @param param
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> updateMediaAppConfig(ReqUpdateMediaAppConfigDto param);

    DubboResult<Integer> insert(MediaAppConfigDto mediaAppConfigDto);
}
