/**
 * Copyright (c) 2018, Ysoul. All rights reserved.
 */
package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaContactManagerDto;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaContactSsoDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.params.MediaContactManagerQuery;

import java.util.List;

/**
 * 类描述: 媒体商务对接人管理查询
 *
 * @author liujianue@duiba.com.cn
 * @version 1.0 2020-02-03
 * @since 1.0
 */
@AdvancedFeignClient
public interface RemoteMediaContactManagerService {

    /**
     * 查询
     *
     * @param id
     * @return
     */
    MediaContactManagerDto selectById(Long id);

    /**
     * 分页查询
     *
     * @param query
     * @return
     */
    PageResultDto<MediaContactManagerDto> selectByParams(MediaContactManagerQuery query);

    /**
     * 统计重复次数
     * @param query
     * @return
     */
    public int selectCountByParams(MediaContactManagerQuery query);

    /**
     * 插入
     *
     * @param mediaContactManagerDto
     * @return
     */
    int insert(MediaContactManagerDto mediaContactManagerDto);

    /**
     * 更新
     *
     * @param mediaContactManagerDto
     * @return
     */
    int update(MediaContactManagerDto mediaContactManagerDto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    int delete(Long id);

    /**
     * 查询所有员工信息
     * @return
     */
    public List<MediaContactSsoDto> getAllMediaContactPeopleList(String employInfo);


}
