package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotCheatingDto;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotConfigDto;
import cn.com.duiba.tuia.ssp.center.api.dto.adx.AdxSlotConfigDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteSlotConfigService {
    int updateSlotConfig(Long slotId, Integer finalRate, String reason);

    Boolean updateSlotConfigBatch(List<SlotCheatingDto> s);

    int updateSlotConfigById(Long slotId, Integer rate);

    List<SlotConfigDto> listBySplitRatioTypeAndDate(Boolean type, String startDate, String endDate);

    Boolean updateSlotPrice(AdxSlotConfigDto dto);

    /**
     * 数据同步
     */
    void syncData();

    boolean updateIdeaDiForTest(Long id, String curDate);

    /**
     * 查询媒体最新风控调整理由
     */
    List<String> listRecentReason(Long appId);

    List<SlotConfigDto> findListBySlotId(List<Long> slotIds);
}
