package cn.com.duiba.tuia.ssp.center.api.remote.industryPenetration.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Optional;

/**
 * 分页信息 :: 分页条件
 * @dateTime 2020-05-13 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
@Accessors(fluent = false, chain = true, prefix = "")
public class GainPaging extends GainCondition implements Serializable {

    /**
     * 页码
     */
    @JsonProperty(value = "currentPage")
    private Integer page;

    /**
     * 条数
     */
    @JsonProperty(value = "pageSize")
    private Integer size;

    /**
     * 下标
     * -- 开始下标
     */
    private Integer subscript;


    /**
     * 验证赋值
     */
    public void validate() {
        int page = Optional.ofNullable(this.getPage()).orElse(1);
        int size = Optional.ofNullable(this.getSize()).orElse(20);
        this.setSubscript((page - 1) * size).setSize(size).setPage(page);
    }

}
