package cn.com.duiba.tuia.ssp.center.api.remote.industryPenetration.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * 对接状态
 * @dateTime 2020-05-13 11:51:27
 * @author haitao.hua
 */
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = true, chain = true, prefix = "")
public enum DockingStatusEnum {


    /*################################# 对接状态的枚举 ( Start ) #####################################*/

    NoDocking("00", 0, 0, "未接入"),
    NoConsume("10", 1, 0, "已接入无消耗"),
    HaveConsume("11", 1, 1, "已接入有消耗");

    /*################################# 对接状态的枚举 ( end ) #######################################*/


    /**
     * 标识码
     */
    @Getter
    private String code;

    /**
     * 对接状态
     * -- { 0 : 未接入 , 1 : 已接入 }
     */
    @Getter
    private int docking;

    /**
     * 消耗状态
     * -- { 0 : 无消耗 , 1 : 有消耗 }
     */
    @Getter
    private int consume;

    /**
     * 备注
     */
    @Getter
    private String remark;


    /**
     * Seek 值
     * @param code 标识码
     * @return 结果
     */
    public static DockingStatusEnum seekValue(String code) {
        Optional<DockingStatusEnum> result = Arrays.stream(DockingStatusEnum.values()).filter(target -> (Objects.nonNull(target) && target.code.equals(code))).findFirst();
        return result.orElse(null);
    }

}
