package cn.com.duiba.tuia.ssp.center.api.remote.media;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaAppDto;
import cn.com.duiba.tuia.ssp.center.api.dto.media.MediaUserInfoDto;

/**
 * created by zhangshun at 2020/06/23
 *
 * 媒体用户信息
 */
@AdvancedFeignClient
public interface RemoteMediaUserService {

    /**
     * 根据AppId 和 用户ID获取用户信息
     * @param appId
     * @param userId
     * @return
     */
    MediaUserInfoDto getUserInfoByAppIdAndUserId(Long appId, String userId) throws BizException;

    /**
     * 根据AppId 和 用户ID获取用户信息
     * @param uri
     * @param userId
     * @param mediaAppDto
     * @return
     */
    MediaUserInfoDto getMediaUserInfoDto(String uri, String userId, MediaAppDto mediaAppDto);

}
