package cn.com.duiba.tuia.ssp.center.api.remote.quickapp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.quickapp.ArticleTagLibraryDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteArticleTagService {

    /**
     * 根据内容由于标签等级精确查询
     * @param content 标签内容
     * @param tagLevel 标签等级
     * @return
     */
    ArticleTagLibraryDto selectOneByContent(String content, Integer tagLevel);

    /**
     * 根据父标签id查询所有子标签
     * @param parentId
     * @return
     */
    List<ArticleTagLibraryDto> selectByParentId(Long parentId);
}
