package cn.com.duiba.tuia.ssp.center.api.remote.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.ssp.center.api.dto.MeidaActivitySlotStatisticsDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqAppStatistics;
import cn.com.duiba.tuia.ssp.center.api.tool.idsquery.IdsQueryParam;

import java.util.List;

/**
 * 〈一句话功能简述〉<br>
 * Description: 媒体统计数据查询远程服务接口
 *
 * @author hillchen
 * @create 2019/1/7 16:56
 */
@AdvancedFeignClient
public interface RemoteAppDataStatisticsService {
    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    IdsQueryParam queryAppIdsByAppStatisticsReq(ReqAppStatistics reqAppStatistics);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    List<MeidaActivitySlotStatisticsDto> selectAppData(IdsQueryParam idsQueryParam, ReqAppStatistics reqAppStatistics);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    Integer selectAppDataCount(IdsQueryParam idsQueryParam,ReqAppStatistics reqAppStatistics);

    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "30000")
    MeidaActivitySlotStatisticsDto selectAppSumData(IdsQueryParam idsQueryParam,ReqAppStatistics reqAppStatistics);
}