package cn.com.duiba.tuia.ssp.center.api.tool.idsquery;

import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/**
 * 〈一句话功能简述〉<br>
 * Description: id和name的查询条件判断参数：
 *
 * @author hillchen
 * @create 2018/11/27 19:58
 */
public class IdsQueryParam implements Serializable {
    private static final long serialVersionUID = 4724027435815659587L;
    private Set<Long> ids;
    private boolean needQuery;

    public boolean isNeedQuery() {
        return needQuery;
    }

    public void setNeedQuery(boolean needQuery) {
        this.needQuery = needQuery;
    }

    public Set<Long> getIds() {
        return ids;
    }

    public void setIds(Set<Long> ids) {
        this.ids = ids;
    }
    /**
     * 将本查询条件和传人查询条件做与查询,当传人集合为空时直接以本查询条件为准
     * @param id
     */
    public void mixedId(Long id){
        if(id != null){
            mixedIds(new HashSet(){{add(id);}});
        }
    }

    /**
     * 将本查询条件和传人查询条件做与查询,当传人集合为空时直接以本查询条件为准
     * @param mixedIds
     */
    public void mixedIds(Collection<Long> mixedIds){
        if(needQuery && CollectionUtils.isNotEmpty(mixedIds)){
            if(CollectionUtils.isNotEmpty(ids)){
                Collection<Long> addIds = CollectionUtils.intersection(ids,mixedIds);
                this.ids = new HashSet<>(addIds);
                needQuery = CollectionUtils.isNotEmpty(addIds);
            }else{
                ids = new HashSet<>(mixedIds);
            }
        }
    }

    /**
     * 将本查询条件和传人查询条件做与查询
     * @param idsQueryParam
     */
    public void mixedIds(IdsQueryParam idsQueryParam){
        if(idsQueryParam.isNeedQuery()){
            mixedIds(idsQueryParam.getIds());
        }else{
            needQuery = false;
        }
    }

    /**
     * 判断是否有查询条件限制
     * @return
     */
    public  boolean notUnlimited(){
        return CollectionUtils.isNotEmpty(getIds());
    }

    public static IdsQueryParam allQueryParam(){
        IdsQueryParam idsQueryParam = new IdsQueryParam();
        idsQueryParam.setNeedQuery(true);
        return idsQueryParam;
    }


    public static IdsQueryParam dontQueryParam(){
        IdsQueryParam idsQueryParam = new IdsQueryParam();
        idsQueryParam.setNeedQuery(false);
        return idsQueryParam;
    }

    public static IdsQueryParam buildIdsQuery(Long id){
        IdsQueryParam idsQueryParam = new IdsQueryParam();
        idsQueryParam.setNeedQuery(true);
        Set<Long> ids = new HashSet<>();
        ids.add(id);
        idsQueryParam.setIds(ids);
        return idsQueryParam;
    }

    public static IdsQueryParam buildIdsQuery(Set<Long> ids){
        IdsQueryParam idsQueryParam = new IdsQueryParam();
        idsQueryParam.setNeedQuery(true);
        Set<Long> queryIds = new HashSet<>();
        idsQueryParam.setIds(queryIds);
        if(CollectionUtils.isNotEmpty(ids)){
            queryIds.addAll(ids);
        }
        return idsQueryParam;
    }
}