package cn.com.duiba.tuia.ssp.center.api.constant;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.nio.charset.StandardCharsets;

/**
 * @author: tangzhen@duiba.com.cn
 * @date:2019-10-24
 * @description:
 **/
public enum ZoomSizeEnum {

    TEN_TEN(1,"缩放尺寸（10%*10%）",0.1D),
    TWENTY_TWENTY(2,"缩放尺寸（20%*20%）",0.2D),
    THIRTY_THIRTY(3,"缩放尺寸（30%*30%）",0.3D),
    FORTY_FORTY(4,"缩放尺寸（40%*40%）",0.4D),
    FIFTY_FIFTY(5,"缩放尺寸（50%*50%）",0.5D),
    EQUAL_RATIO(6,"广告位规格长宽等比",0D);

    private Integer type;

    private String desc;

    private Double flot;

    ZoomSizeEnum(Integer type, String desc, Double flot) {
        this.type = type;
        this.desc = desc;
        this.flot = flot;
    }
    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public Double getFlot() {
        return flot;
    }

    public static JSONArray getAll() {
        JSONArray jsons = new JSONArray();
        for (ZoomSizeEnum size : ZoomSizeEnum.values()) {
            JSONObject json = new JSONObject();
            json.put("type", size.getType());
            json.put("size", size.getDesc());
            jsons.add(json);
        }
        return jsons;
    }

    public static ZoomSizeEnum getByType(Integer type){
        for (ZoomSizeEnum value : ZoomSizeEnum.values()) {
            if (value.type.equals(type)) {
                return value;
            }
        }
        return null;
    }
}
