package cn.com.duiba.tuia.ssp.center.api.constant.dmp;

/**
 * @author zhangzichen
 */

public enum CrowdTypeEnum {

    PRIVATE_CROWD(1,"PRIVATE_CROWD","私有人群包"),
    TRADE_CROWD(2,"TRADE_CROWD","行业人群包"),
    BUSINESS_INTEREST_LABEL_CROWD(3,"BUSINESS_INTEREST_LABEL_CROED","商业兴趣标签"),
    SYSTEM_ALGORITHM_CROWD(4,"SYSTEM_ALGORITHM_CROWD","系统推荐人群包（算法）"),
    CLOSE_CROWD(6,"CLOSE_CROWD","关闭"),

    //此处enum只有代码规范的作用，没有其他的实际作用，因为以前的人将crowdType这个字段维护到了tb_dmp_crowd_type表中。
    // 所以此时如果要增加enum值的话则还要操作数据库。
    GENERAL_CROWD(9,"GENERAL_CROWD","通用人群"),
    BETA_CROWD(10,"BETA_CROWD","人群Beta"),
    CUSTOM_CROWD(11,"CUSTOM_CROWD","自定义人群")
    ;

    private Integer type;

    private String code;

    private String desc;

    CrowdTypeEnum(Integer type, String code, String desc) {
        this.type = type;
        this.code = code;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
