package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel
public class MaterialBatchAuditDto implements Serializable {

    /**
     * 素材id列表
     */
    @ApiModelProperty(value = "素材id列表")
    private List<Long> materialIds;

    /**
     * 审核状态
     */
    @ApiModelProperty(value = "审核状态 (1:待审核 2:审核通过 3:审核拒绝)")
    private Integer auditStatus;

    /**
     * 拒绝原因
     */
    @ApiModelProperty(value = "拒绝原因")
    private String rejectReason;

    //媒体用户id
    private Long mediaId;

    //媒体用户可见媒体id列表
    private List<Long> midList;

}
