package cn.com.duiba.tuia.ssp.center.api.params.dmp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("标签管理入参类")
public class LabelManagerParms {
    @ApiModelProperty("app名称")
    private String appName;
    @ApiModelProperty("标签ID")
    private Long id;
    @ApiModelProperty("规则名称列表，英文逗号分隔")
    private String ruleNameList;
    @ApiModelProperty("规则名称")
    private String ruleName;
    @ApiModelProperty("映射逻辑 ：  不传值null :包含 +等于 ，1：包含， 2：等于")
    private Integer mapLogic;
    @ApiModelProperty("规则type：   不传值null :短信+app名称，  1： 短信签名，  2：app名称")
    private Integer ruleType;

    @ApiModelProperty("规则ID")
    private Long ruleId;
    @ApiModelProperty("根节点codeValue")
    private String rootValue;
    @ApiModelProperty("根节点名称")
    private String rootLabel;
    @ApiModelProperty("当前标签编码")
    private String value;
    @ApiModelProperty("当前标签名称")
    private String label;
    @ApiModelProperty("父标签编码")
    private String parentValue;
    @ApiModelProperty("父标签名称")
    private String parentLabel;
    @ApiModelProperty("子标签编码")
    private String childValue;
    @ApiModelProperty("层级类型")
    private Integer levelType;
    @ApiModelProperty("数据状态")
    private Integer status;
    @ApiModelProperty("标签备注")
    private String remark;
    @ApiModelProperty("标签条件数据")
    private DmpUserLabelRegulationParam regulation;

    private Long adminId;
    private String adminName;
    private Integer pageNum;
    private Integer pageSize;
}
