package cn.com.duiba.tuia.ssp.center.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2022/4/8
 * @Description
 * @Param
 * @return
 **/
@Data
public class ProgrammaticMediaReportConfigHisDTO {
    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    private Long id;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date gmtCreate;
    /**
     * 修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date gmtModified;
    /**
     * 删除标识 0-否 1-是
     */
    private Integer isDeleted;
    /**
     * 上报策略ID
     */
    private Long reportStrategyHisId;
    /**
     * 上报策略id列表
     */
    private List<Long> reportStrategyHisIds;
    /**
     * 上报维度 1-全局维度 2- 广告资源维度 3-广告维度
     */
    private Integer reportDimension;
    /**
     * 标签ID
     */
    private String tagId;
    /**
     * 广告计划ID
     */
    private Long advertId;
    /**
     * 推啊上报节点
     */
    private Integer tuiaType;
    /**
     * 媒体上报节点
     */
    private String mediaType;
    /**
     * 上报概率
     */
    private Integer returnProbability;
    /**
     * 固定收益
     */
    private Long income;

    /**
     * 行业id
     */
    private Integer industry;
    /**
     * 推啊助攻节点
     */
    private Integer assistingSubtype;


    private String areaCode;
}
