package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;

import java.util.Date;
import java.util.List;

/**
 * 广告位维度查询消耗
 */
@AdvancedFeignClient
public interface RemoteSlotConsumeService {

    /**
     * 根据广告位id与行业id查询消耗
     * @param slotId
     * @param industryId
     * @return
     */
    DmSlotIndustryConsumeDsm2a1BasicDto selectSlotIndustryConsumeBySlotIdAndIndustryId(Long slotId, Long industryId, Date date);

    /**
     * 根据广告位id查询消耗
     * @param slotId
     * @return
     */
    DmSlotConsumeDsm2a1BasicDto selectSlotConsumeBySlotId(Long slotId,Date date);

    /**
     * 根据广告位id查询对应的活动消耗列表
     * @param slotId
     * @param date
     * @return
     */
    List<DmSlotActivityConsumeDsm2a1BasicDto> selectSlotActivityListBySlotId(Long slotId,Date date);

    /**
     * 批量查询广告位近7日消耗，定时任务巡查用
     *
     * @param slotIds
     * @return
     */
    List<SlotConsumeDTO> querySlotConsumeInSevenDays(List<Long> slotIds);

}
