package cn.com.duiba.tuia.ssp.center.api.dto.cpa;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
* cpa预算利润数据表
*/
public class CpaDailyProfitDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
    * 现金结算收入
    */
    private BigDecimal cashIncome;

    /**
    * 现金利润
    */
    private BigDecimal cashProfit;

    /**
    * 日期
    */
    private Date curDate;

    /**
    * 每日利润
    */
    private BigDecimal dailyProfit;

    /**
    * 备注
    */
    private String dataDesc;

    /**
    * 0:未确认，1:已确认
    */
    private Integer dataType;

    /**
    * 买量支出
    */
    private BigDecimal expenses;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新时间
    */
    private Date gmtModified;

    /**
    * id
    */
    private Long id;

    /**
    * 媒体返点
    */
    private BigDecimal mediaRebate;

    /**
    * 运营id
    */
    private Long operatorId;

    /**
    * 运营名称
    */
    private String operatorName;

    /**
    * 平台ID
    */
    private Long platformId;

    /**
    * 平台名称
    */
    private String platformName;

    /**
    * 产品id
    */
    private Long productId;

    /**
    * 产品名称
    */
    private String productName;

    /**
    * 核减比例
    */
    private BigDecimal reductionRatio;

    /**
    * 结算收入
    */
    private BigDecimal settlementIncome;


    public void setCashIncome(BigDecimal cashIncome) {
        this.cashIncome = cashIncome;
    }

    public BigDecimal getCashIncome() {
        return cashIncome;
    }

    public void setCashProfit(BigDecimal cashProfit) {
        this.cashProfit = cashProfit;
    }

    public BigDecimal getCashProfit() {
        return cashProfit;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setDailyProfit(BigDecimal dailyProfit) {
        this.dailyProfit = dailyProfit;
    }

    public BigDecimal getDailyProfit() {
        return dailyProfit;
    }

    public void setDataDesc(String dataDesc) {
        this.dataDesc = dataDesc;
    }

    public String getDataDesc() {
        return dataDesc;
    }

    public void setDataType(Integer dataType) {
        this.dataType = dataType;
    }

    public Integer getDataType() {
        return dataType;
    }

    public void setExpenses(BigDecimal expenses) {
        this.expenses = expenses;
    }

    public BigDecimal getExpenses() {
        return expenses;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setMediaRebate(BigDecimal mediaRebate) {
        this.mediaRebate = mediaRebate;
    }

    public BigDecimal getMediaRebate() {
        return mediaRebate;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setPlatformId(Long platformId) {
        this.platformId = platformId;
    }

    public Long getPlatformId() {
        return platformId;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public String getPlatformName() {
        return platformName;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductName() {
        return productName;
    }

    public void setReductionRatio(BigDecimal reductionRatio) {
        this.reductionRatio = reductionRatio;
    }

    public BigDecimal getReductionRatio() {
        return reductionRatio;
    }

    public void setSettlementIncome(BigDecimal settlementIncome) {
        this.settlementIncome = settlementIncome;
    }

    public BigDecimal getSettlementIncome() {
        return settlementIncome;
    }

}

