package cn.com.duiba.tuia.ssp.center.api.dto.dmp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.htrace.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonIgnoreProperties({ "handler","hibernateLazyInitializer" })
@ApiModel("分析内容返回类")
public class AnalysisContentDto {
    @ApiModelProperty("新用户占比，后端返回4位小数，无穷大返回Infinity")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private String newUserPro;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private Double newUsers;
    @ApiModelProperty("老用户占比，后端返回4位小数，无穷大返回Infinity")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private String oldUserPro;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private Double oldUsers;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private Double totalUsers;
    @ApiModelProperty("可识别占比，后端返回4位小数，无穷大返回Infinity")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private String identifyPro;

    @ApiModelProperty("行业名称")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private String tradeName;

    @ApiModelProperty("年龄段名称")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private String ageName;

    @ApiModelProperty("发券量")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private Double launchPv;
    @ApiModelProperty("点击量")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private Double efClickPv;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private Double efClickUv;

    @ApiModelProperty("点击率，后端返回4位小数，无穷大返回Infinity，某行业的点击量/发券量")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private String clickPvRate;
    @ApiModelProperty("转化量")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private Double effectPv;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private Double effectUv;

    @ApiModelProperty("转化率，后端返回4位小数，无穷大返回Infinity ；转化率：转化量/点击量")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private String effectPvRate;

    @ApiModelProperty("男性占比，后端返回4位小数，无穷大返回Infinity")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private String malePro;
    @ApiModelProperty("女性占比，后端返回4位小数，无穷大返回Infinity")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private String felMalePro;

    @ApiModelProperty("大盘占比，后端返回4位小数，无穷大返回Infinity")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private String dashboardPro;

    @ApiModelProperty("人群占比，后端返回4位小数，无穷大返回Infinity")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private String crowdPro;

    @ApiModelProperty("TGI，后端返回4位小数，无穷大返回Infinity")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private Double TGI;
     @ApiModelProperty("一级标签")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private String label1;
    @ApiModelProperty("二级标签")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private String label2;
    @ApiModelProperty("三级标签")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private String label3;
    @ApiModelProperty("消费标签")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private String consumerLabel;

    public String getNewUserPro() {
        return newUserPro;
    }

    public void setNewUserPro(String newUserPro) {
        this.newUserPro = newUserPro;
    }

    public Double getNewUsers() {
        return newUsers;
    }

    public void setNewUsers(Double newUsers) {
        this.newUsers = newUsers;
    }

    public String getOldUserPro() {
        return oldUserPro;
    }

    public void setOldUserPro(String oldUserPro) {
        this.oldUserPro = oldUserPro;
    }

    public Double getOldUsers() {
        return oldUsers;
    }

    public void setOldUsers(Double oldUsers) {
        this.oldUsers = oldUsers;
    }

    public Double getTotalUsers() {
        return totalUsers;
    }

    public void setTotalUsers(Double totalUsers) {
        this.totalUsers = totalUsers;
    }

    public String getIdentifyPro() {
        return identifyPro;
    }

    public void setIdentifyPro(String identifyPro) {
        this.identifyPro = identifyPro;
    }

    public String getTradeName() {
        return tradeName;
    }

    public void setTradeName(String tradeName) {
        this.tradeName = tradeName;
    }

    public String getAgeName() {
        return ageName;
    }

    public void setAgeName(String ageName) {
        this.ageName = ageName;
    }

    public Double getLaunchPv() {
        return launchPv;
    }

    public void setLaunchPv(Double launchPv) {
        this.launchPv = launchPv;
    }

    public Double getEfClickPv() {
        return efClickPv;
    }

    public void setEfClickPv(Double efClickPv) {
        this.efClickPv = efClickPv;
    }

    public String getClickPvRate() {
        return clickPvRate;
    }

    public void setClickPvRate(String clickPvRate) {
        this.clickPvRate = clickPvRate;
    }

    public Double getEffectPv() {
        return effectPv;
    }

    public void setEffectPv(Double effectPv) {
        this.effectPv = effectPv;
    }

    public String getEffectPvRate() {
        return effectPvRate;
    }

    public void setEffectPvRate(String effectPvRate) {
        this.effectPvRate = effectPvRate;
    }

    public String getMalePro() {
        return malePro;
    }

    public void setMalePro(String malePro) {
        this.malePro = malePro;
    }

    public String getFelMalePro() {
        return felMalePro;
    }

    public void setFelMalePro(String felMalePro) {
        this.felMalePro = felMalePro;
    }

    public String getDashboardPro() {
        return dashboardPro;
    }

    public void setDashboardPro(String dashboardPro) {
        this.dashboardPro = dashboardPro;
    }

    public String getCrowdPro() {
        return crowdPro;
    }

    public void setCrowdPro(String crowdPro) {
        this.crowdPro = crowdPro;
    }

    public Double getTGI() {
        return TGI;
    }

    public void setTGI(Double TGI) {
        this.TGI = TGI;
    }

    public String getLabel1() {
        return label1;
    }

    public void setLabel1(String label1) {
        this.label1 = label1;
    }

    public String getLabel2() {
        return label2;
    }

    public void setLabel2(String label2) {
        this.label2 = label2;
    }

    public String getLabel3() {
        return label3;
    }

    public void setLabel3(String label3) {
        this.label3 = label3;
    }

    public String getConsumerLabel() {
        return consumerLabel;
    }

    public void setConsumerLabel(String consumerLabel) {
        this.consumerLabel = consumerLabel;
    }

    public Double getEfClickUv() {
        return efClickUv;
    }

    public void setEfClickUv(Double efClickUv) {
        this.efClickUv = efClickUv;
    }

    public Double getEffectUv() {
        return effectUv;
    }

    public void setEffectUv(Double effectUv) {
        this.effectUv = effectUv;
    }
}
