package cn.com.duiba.tuia.ssp.center.api.dto.finaceData.req;

import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;

public class ManualSlotDailyStatReq {

    /**序列号*/
    private static final long serialVersionUID = -1830650539606129671L;

    /** The id. */
    protected Long            id;

    /** 创建时间. */
    protected Date            gmtCreate;

    /** 最新更新时间. */
    protected Date            gmtModified;

    /**媒体ID*/
    private Long appId;

    /**广告位ID*/
    @ApiModelProperty(value = "广告位ID", required = true)
    @NotNull(message = "广告位ID不能为空")
    private Long slotId;

    /**当天日期*/
    @ApiModelProperty(value = "当前日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "日期不能为空")
    private Date curDate;

    /**广告位曝光PV*/
    @ApiModelProperty(value = "广告位曝光pv", required = false)
    private Long actExposeCount;

    /**广告位点击PV*/
    @ApiModelProperty(value = "广告位点击pv", required = false)
    private Long actClickCount;

    /**广告位点击UV*/
    @ApiModelProperty(value = "广告位点击uv", required = false)
    private Long actClickUv;

    /**广告uv单价*/
    @ApiModelProperty(value = "广告uv单价", required = false)
    private Long slotUvPrice;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getAppId() {
        return appId;
    }


    public void setAppId(Long appId) {
        this.appId = appId;
    }


    public Long getSlotId() {
        return slotId;
    }


    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }


    public Date getCurDate() {
        return curDate;
    }


    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }


    public Long getActExposeCount() {
        return actExposeCount;
    }


    public void setActExposeCount(Long actExposeCount) {
        this.actExposeCount = actExposeCount;
    }


    public Long getActClickCount() {
        return actClickCount;
    }


    public void setActClickCount(Long actClickCount) {
        this.actClickCount = actClickCount;
    }


    public Long getActClickUv() {
        return actClickUv;
    }


    public void setActClickUv(Long actClickUv) {
        this.actClickUv = actClickUv;
    }

    public Long getSlotUvPrice() {
        return slotUvPrice;
    }

    public void setSlotUvPrice(Long slotUvPrice) {
        this.slotUvPrice = slotUvPrice;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
