package cn.com.duiba.tuia.ssp.center.api.dto;

import cn.com.duiba.tuia.ssp.center.api.util.DateUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

@Data
@ApiModel
public class MaterialAuditDto implements Serializable {
    /**
     * 素材id
     */
    @ApiModelProperty(value = "素材id")
    private Long materialId;

    /**
     * 素材信息
     */
    @ApiModelProperty(value = "素材信息")
    private String materialJson;

    /**
     * 审核状态
     */
    @ApiModelProperty(value = "审核状态 (1:待审核 2:审核通过 3:审核拒绝)")
    private Integer auditStatus;

    /**
     * 素材尺寸
     */
    @ApiModelProperty(value = "素材尺寸")
    private String materialSize;

    /**
     * 素材标题
     */
    @ApiModelProperty(value = "素材标题")
    private String materialTitle;

    /**
     * 素材描述
     */
    @ApiModelProperty(value = "素材描述")
    private String materialDesc;

    /**
     * 落地页地址
     */
    @ApiModelProperty(value = "落地页地址")
    private String landPageUrl;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    private String createTimeStr;

    /**
     * 审核时间
     */
    @ApiModelProperty(value = "审核时间")
    private Date auditTime;

    private String auditTimeStr;

    /**
     * 拒绝原因
     */
    @ApiModelProperty(value = "拒绝原因")
    private String rejectReason;

    //媒体id
    private Long mid;

    public String getAuditTimeStr() {
        if (auditTime != null) {
            return DateUtils.format(createTime, "yyyy-MM-dd HH:mm:ss");
        }
        return "";
    }

    public String getCreateTimeStr() {
        if (createTime != null) {
            return DateUtils.format(createTime, "yyyy-MM-dd HH:mm:ss");
        }
        return "";
    }
}
