package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description  广告位尺寸DTO (根据规格尺寸和规格两个对象整合而来)
 * @Date 16:56 2020-10-27
 * @Param
 * @return
 **/
@Data
public class SlotSpecificationDto implements Serializable {

    private static final long                            serialVersionUID = 5739295312511609423L;

    @ApiModelProperty(value = "ID")
    private Long  id;

    @ApiModelProperty(value = "规格ID")
    private Long  msId;

    @ApiModelProperty(value = "尺寸标题")
    private String title;

    @ApiModelProperty(value = "素材类型")
    private Integer  itemType;

    @ApiModelProperty(value = "宽度")
    private Integer  imageWidth;

    @ApiModelProperty(value = "高度")
    private Integer  imageHeight;

    @ApiModelProperty(value = "排序字段")
    private Integer  sort;

    @ApiModelProperty(value = "备注")
    private String  description;

    @ApiModelProperty(value = "新增人员ID")
    private Long managerId;

    @ApiModelProperty(value = "新增人员名字")
    private String      managerName;

    @ApiModelProperty(value = "创建时间")
    private String gmtCreate;

    @ApiModelProperty(value = "模板类型 0=自定义、1=上文下图、2=左文右图、3=左图右文、4=三图")
    private Integer templateType;

    @ApiModelProperty(value = "是否固定数据,固定数据不允许删除,1-固定 0-允许删除")
    private Integer isfixedData;

    @ApiModelProperty(value = "是否标准尺寸")
    private Integer isStandard;

}
