package cn.com.duiba.tuia.ssp.center.api.dto.prePayInvoiceRecord;

import lombok.Data;

import java.io.Serializable;

/**
* 预付款发票纪录表
*/
@Data
public class PrePayInvoiceRecordDto implements Serializable {

    private static final long serialVersionUID = 8222300069764460482L;

    /**
     * The id.
     */
    protected Long id;

    /**
     * 创建时间.
     */
    protected String gmtCreate;

    /**
    * 媒体用户ID
    */
    private Long mediaId;

    /**
    * 操作人员ID
    */
    private Long managerId;

    /**
     * 操作人姓名
     */
    private String managerName;

    /**
    * 开户名称
    */
    private String openAccount;

    /**
    * 开票方式：0-消耗 1-打款
    */
    private Integer invoiceWay;

    /**
    * 开票主体：0-杭州 1-霍尔果斯 2-霍城兑捷
    */
    private Integer invoiceBody;

    /**
    * 发票金额
    */
    private Long invoiceAmount;

    /**
    * 发票编号
    */
    private String invoiceNumber;

    /**
    * 请款日期(yyyy-MM-dd)
    */
    private String paymentDate;

    /**
    * 打款日期(yyyy-MM-dd)
    */
    private String payDate;

    /**
    * 发票收到日期(yyyy-MM-dd)
    */
    private String invoiceReceiveDate;

    /**
    * 发票状态：0-媒介助理 1-已提交财务
    */
    private Integer invoiceStatus;

    /**
    * 提交财务日期
    */
    private String submitFinanceDate;

    /**
    * 备注
    */
    private String remark;

    /**
     * 预付款订单ID
     */
    private Long prePayOrderId;

    /**
     * 发票照片
     */
    private String pictureUrl;

    /**
     * 发票税额
     */
    private Long invoiceTaxAmount;

    /**
     * 不含税金额
     */
    private Long invoiceNotIncludedTaxAmount;

    /**
     * 购买方名称
     */
    private String customerName;

    /**
     * 购买方纳税人识别号
     */
    private String customerNo;

    /**
     * 销售方名称
     */
    private String sellerName;

    /**
     * 销售方纳税人识别号
     */
    private String sellerNo;

    /**
     * 开票日期（格式：yyyy-MM-dd）
     */
    private String invoiceDate;

    /**
     * 税率
     */
    private Integer taxRatio;

    /**
     * 发票状态（0：待审核 1：审核通过 2：审核拒绝）
     */
    private Integer invoiceCheckStatus;

    /**
     * 发票审核原因
     */
    private String checkReason;
}

