/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.subscribe.api.enums;

import java.util.stream.Stream;

public enum OperatorEnum {
    UNKNOWN(0, "uk", "\u672a\u77e5", false),
    MOBILE(1, "yd", "\u79fb\u52a8", true),
    TELECOM(2, "dx", "\u7535\u4fe1", true),
    UNICOM(3, "lt", "\u8054\u901a", true),
    BROADCAST_TELEVISION(4, "gd", "\u5e7f\u7535", true);

    private final Integer code;
    private final String type;
    private final String desc;
    private final boolean display;

    private OperatorEnum(Integer code, String type, String desc, boolean display) {
        this.code = code;
        this.type = type;
        this.desc = desc;
        this.display = display;
    }

    public static OperatorEnum getByCode(Integer code) {
        return Stream.of(OperatorEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(MOBILE);
    }

    public static OperatorEnum getByType(String type) {
        return Stream.of(OperatorEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(MOBILE);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isDisplay() {
        return this.display;
    }
}

