package cn.com.duiba.tuia.subscribe.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2023/12/21.
 */
@Getter
public enum GuangDianOrderStatusEnum {
    UNKNOWN(99, "unknown", "未知"),
    PENDING_PAYMENT(0, "pendingPayment", "待付款"),
    ORDER_PROCESSING(1, "orderProcessing", "订单正在处理"),
    COMPLETED(2, "completed", "已完结"),
    CANCELLED(3, "cancelled", "已取消订单成功"),
    ORDER_FAILURE(4, "orderFailure", "下单失败"),
    ORDER_DELIVERY(5, "orderDelivery", "订单正在配送途中"),
    DELIVERED(6, "delivered", "已完成"),
    REFUSED(7, "refused", "已配送到达且已拒签"),
    ORDER_SUCCESS(8, "orderSuccess", "下单成功"),
    ;
    private final Integer code;
    private final String type;
    private final String desc;

    GuangDianOrderStatusEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static GuangDianOrderStatusEnum getByCode(Integer code) {
        return Stream.of(GuangDianOrderStatusEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(UNKNOWN);
    }

    public static GuangDianOrderStatusEnum getByType(String type) {
        return Stream.of(GuangDianOrderStatusEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(UNKNOWN);
    }

    public static GuangDianOrderStatusEnum getByDesc(String desc) {
        return Stream.of(GuangDianOrderStatusEnum.values()).filter(e -> e.getDesc().equals(desc)).findFirst().orElse(UNKNOWN);
    }
}
