package cn.com.duiba.tuia.subscribe.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2024/3/5.
 */
@Getter
public enum OperatorEnum {

    UNKNOWN(0, "uk", "未知",false),
    MOBILE(1, "yd", "移动",true),
    TELECOM(2, "dx", "电信",true),
    UNICOM(3, "lt", "联通",true),
    BROADCAST_TELEVISION(4, "gd", "广电",true),
    ;
    private final Integer code;
    private final String type;
    private final String desc;
    private final boolean display;

    OperatorEnum(Integer code, String type, String desc,boolean display) {
        this.code = code;
        this.type = type;
        this.desc = desc;
        this.display = display;

    }

    public static OperatorEnum getByCode(Integer code) {
        return Stream.of(OperatorEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(UNKNOWN);
    }

    public static OperatorEnum getByType(String type) {
        return Stream.of(OperatorEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(UNKNOWN);
    }
}
