package cn.tuia.tuia.treasure.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.tuia.treasure.center.api.dto.*;

import java.util.List;

/**
 * Created by zhou_wb on 2018/4/23.
 */
@AdvancedFeignClient
public interface RemoteArticleService {

    /**
     * 根据id 查询文章信息
     * @param id
     * @return
     */
    ArticleDto selectById(Long id);


    /**
     * 分页查询文章
     * @param articleQueryDto
     * @return
     */
    PageQueryResultDto<ArticleDto> selectList(ArticleQueryDto articleQueryDto);


    /**
     * 批量更新文章状态
     */
    void  batchUpdateArticleStatus(List<ArticleStatusDto> articleStatusDtos);

    /**
     * 更新置顶文章状态
     */
    void updateArticleStickStatus(ArticleStickStatusDto articleStickStatusDto);

    /**
     * 根据账号Id批量更新文章状态(账号下线时，文章批量下线)
     */
    void  batchUpdateArticleStatusByAccountIds(List<Long> ids ,Integer status);

    /**
     * 根据文章ids查询
     */
    List<ArticleDto> selectByArticleIds(List<Long> ids);

    /**
     * 根据文章标题模糊查询
     */
    List<Long> selectLikeTitle(String title);

    /**
     * 根据文章ids 查询所有状态文章
     */
    List<ArticleDto> selectByIdsForAllStatus(List<Long> ids);

    /**
     * 根据文章标题模糊查询所有状态
     */
    List<Long> selectLikeTitleForAllStatus(String title);

    /**
     * 根据文章id，获取编辑页面数据
     */
    ArticleEditAbleDto selectByIdForEdit(Long articleId);


    /**
     * 保存编辑后的文章数据
     */
    Boolean saveArticle(ArticleEditAbleDto articleEditAbleDto);

    /**
     * 插入第三方文章
     * @param articleThirdDto
     * @return
     */
    Boolean insertThirdArticle(ArticleThirdDto articleThirdDto);

    /**
     * 根据作者id查询所有文章
     * @param accountIds
     * @return
     */
    List<ArticleDto> selectByAccountIds(List<Long> accountIds);

}
