package cn.tuia.tuia.treasure.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.tuia.treasure.center.api.dto.PageQueryResultDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.newsarticledata.NewsTotalDailyDataDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.newsarticledata.agentaspect.NewsArticleDailyDataAgentAspectDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.newsarticledata.agentaspect.NewsArticleDailyDataAgentAspectQueryDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.newsarticledata.articleaspect.NewsArticleDailyDataArticleAspectDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.newsarticledata.articleaspect.NewsArticleDailyDataArticleQueryDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.newsarticledata.mediaaccountaspect.NewsArticleDailyDataMediaAccountAspectDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.newsarticledata.mediaaccountaspect.NewsArticleDailyDataMediaAccountQueryDto;

/**
 * Created by zhou_wb on 2018/5/28.
 */
@AdvancedFeignClient
public interface RemoteStatisticsService {

    /**
     * 查询自媒体维度分页数据
     */
    PageQueryResultDto<NewsArticleDailyDataMediaAccountAspectDto>  mediaAccountAspectQuery(NewsArticleDailyDataMediaAccountQueryDto query);


    /**
     * 查询文章维度分页数据
     */
    PageQueryResultDto<NewsArticleDailyDataArticleAspectDto> articleAspectquery(NewsArticleDailyDataArticleQueryDto query);


    /**
     * 查询代理商维度分页数据
     */
    PageQueryResultDto<NewsArticleDailyDataAgentAspectDto> query(NewsArticleDailyDataAgentAspectQueryDto query);

    /**
     * 根据代理商ids查询数据子账号总收益
     * @param query  取 mediaAccountIds 和 开始结束时间
     * @return
     */
    PageQueryResultDto<NewsArticleDailyDataAgentAspectDto> agentAspectQuery(NewsArticleDailyDataAgentAspectQueryDto query);

    /**
     * 根据时间段查询数据总计数据
     * @param start  开始时间
     * @param end   结束时间
     * @return
     */
    NewsTotalDailyDataDto selectByListBetweenCurDate(String start, String end );
}
