package cn.tuia.tuia.treasure.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.tuia.treasure.center.api.dto.ArticleHotDto;
import cn.tuia.tuia.treasure.center.api.dto.PageQueryResultDto;
import cn.tuia.tuia.treasure.center.api.dto.WechatHotArticleDto;
import cn.tuia.tuia.treasure.center.api.dto.hotarticle.HotArticleCategoryDto;
import cn.tuia.tuia.treasure.center.api.dto.hotarticle.HotArticleDto;
import cn.tuia.tuia.treasure.center.api.dto.hotarticle.HotArticleQueryDto;

import java.util.List;

/**
 * @author wsz
 * @date 2018/10/25 13:46
 */
@AdvancedFeignClient
public interface RemoteWechatHotArticleService {
    /**
     * 查询文章列表
     */
    PageQueryResultDto<HotArticleDto> selectList(HotArticleQueryDto hotArticleQueryDto);

    /**
     * 获取类别列表
     */
    List<HotArticleCategoryDto> selectCategories();

    /**
     * 获取发布热文
     *
     */
    List<WechatHotArticleDto> selectIsPublish();

    /**
     * 获取所有微信热门列表
     * @return
     */
    List<ArticleHotDto> selectAllArticleHotList();

    /**
     * 修改热门的微信列表排序
     * @param ids
     * @return
     */
    int updateArticleHotListSort(List<Long> ids);

    /**
     * 替换热门微信
     * @param articleHotDto
     * @return
     */
    int replaceArticleHot(ArticleHotDto articleHotDto);


}
