package cn.tuia.tuia.treasure.center.api.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * @Auther: wsz
 * @Date: 2018/7/19 16:30
 * @Description:文章来源
 */
public enum ArticleSource {
    WECHAT(1,"微信公众号"),
    WQQS(2,"维权骑士"),
    WULI(3,"WuLi头条"),
    NTES(4,"网易有料"),
    WCHA(5,"微信热文"),
    IFENG(6,"凤凰热文"),
    TOUTIAO(7,"今日头条"),
    WANGYI(8,"网易热文"),
    NRANK(9,"新榜热文"),
    QUTOUTIAO(10,"趣头条"),
    JIN(11,"环京津网")
    ;
    private Integer code;
    private String desc;

    ArticleSource(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }



    private static final Map<Integer, ArticleSource> CACHE = Maps.uniqueIndex(Arrays.asList(ArticleSource
            .values()), ArticleSource::getCode);

    public static ArticleSource of(Integer code) {
        return CACHE.get(code);
    }
}
