package cn.tuia.tuia.treasure.center.api.enums;

public enum VideoSourceEnums {
    MEI_PAI(0, "美拍"),
    TANG_DOU(1, "糖豆"),
    OTHER(2, "手动"),
    KU_RAN(3, "酷燃"),
    ZUI_YOU(4, "最右"),
    BSBDJ(5, "百思不得姐"),
    QUTT(6,"趣头条"),
    BAIDU(7, "百度"),
    ;

    private Integer code;

    private String desc;

    VideoSourceEnums(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static VideoSourceEnums getByCode(Integer code) {
        for (VideoSourceEnums value : VideoSourceEnums.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
    public static VideoSourceEnums getByName(String name) {
        for (VideoSourceEnums value : VideoSourceEnums.values()) {
            if (value.getDesc().equals(name)) {
                return value;
            }
        }
        return null;
    }

}
