package cn.tuia.tuia.treasure.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.tuia.treasure.center.api.dto.PageQueryResultDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.AccountArticleIncreaseDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.AccountArticleIncreaseReqDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.AccountFinalIncomeDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.AccountTotalDataDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.accountreport.TotalIncomeReqDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.newsarticledata.AgentIncomeDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.newsarticledata.NewsTotalDailyDataDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.newsarticledata.agentaspect.NewsArticleDailyDataAgentAspectDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.newsarticledata.agentaspect.NewsArticleDailyDataAgentAspectQueryDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.newsarticledata.articleaspect.NewsArticleDailyDataArticleAspectDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.newsarticledata.articleaspect.NewsArticleDailyDataArticleQueryDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.newsarticledata.mediaaccountaspect.NewsArticleDailyDataMediaAccountAspectDto;
import cn.tuia.tuia.treasure.center.api.dto.statistics.newsarticledata.mediaaccountaspect.NewsArticleDailyDataMediaAccountQueryDto;

import java.util.List;

/**
 * Created by zhou_wb on 2018/5/28.
 */
@AdvancedFeignClient
public interface RemoteStatisticsService {

    /**
     * 查询自媒体维度分页数据(时间维度)
     */
    PageQueryResultDto<NewsArticleDailyDataMediaAccountAspectDto>  mediaAccountCurDateAspectQuery(NewsArticleDailyDataMediaAccountQueryDto query);

    /**
     * 查询自媒体维度分页数据(自媒体维度)
     */
    PageQueryResultDto<NewsArticleDailyDataMediaAccountAspectDto>  mediaAccountAspectQuery(NewsArticleDailyDataMediaAccountQueryDto query);


    /**
     * 查询文章维度分页数据（详情 ）
     */
    PageQueryResultDto<NewsArticleDailyDataArticleAspectDto> articleAspectQueryDetail(NewsArticleDailyDataArticleQueryDto query);

    /**
     * 查询文章维度分页数据
     */
    PageQueryResultDto<NewsArticleDailyDataArticleAspectDto> articleAspectQuery(NewsArticleDailyDataArticleQueryDto query);



    /**
     * 查询代理商维度分页数据
     */
    PageQueryResultDto<NewsArticleDailyDataAgentAspectDto> query(NewsArticleDailyDataAgentAspectQueryDto query);

    /**
     * 根据代理商ids查询时间维度数据
     * @param query  取 mediaAccountIds 和 开始结束时间
     * @return
     */
    PageQueryResultDto<NewsArticleDailyDataAgentAspectDto> agentAspectBetweenCurDateQuery(NewsArticleDailyDataAgentAspectQueryDto query);


    /**
     * 根据代理商ids查询 （代理商维度）
     * @param query  取 mediaAccountIds 和 开始结束时间
     * @return
     */
    PageQueryResultDto<NewsArticleDailyDataAgentAspectDto> agentAspectQuery(NewsArticleDailyDataAgentAspectQueryDto query);

    /**
     * 根据时间段查询数据总计数据
     * @param start  开始时间
     * @param end   结束时间
     * @return
     */
    NewsTotalDailyDataDto selectByListBetweenCurDate(String start, String end );

    /**
     * 根据账号Id与账号类型获取总收益数据（自媒体平台）
     */

    AccountTotalDataDto getAccountTotalSum(TotalIncomeReqDto totalIncomeReqDto);


    /**
     * 查询账号每日新增文章数据
     */
    List<AccountArticleIncreaseDto> getIncreaseArticleCount(AccountArticleIncreaseReqDto accountArticleIncreaseReqDto);


    /**
     * 获取代理商账号下子账号新增文章数量
     */
    List<AccountArticleIncreaseDto> getIncreaseArticleCountForAgentAspect(AccountArticleIncreaseReqDto accountArticleIncreaseReqDto);

    /**
     * 获取子账号或者自媒体每日预估收益接口
     */
    List<AccountFinalIncomeDto>  getAccountFinalIncomeDto(AccountArticleIncreaseReqDto accountArticleIncreaseReqDto);


    /**
     * 更新代理商的最终收益
     */
    boolean updateAgentFinalIncome(AgentIncomeDto agentIncomeDto);
}
