package cn.tuia.tuia.treasure.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.tuia.treasure.center.api.dto.ExpectDto;
import cn.tuia.tuia.treasure.center.api.dto.ExpectOutDto;
import cn.tuia.tuia.treasure.center.api.dto.RecomeDto;
import cn.tuia.tuia.treasure.center.api.dto.StickContentDto;
import cn.tuia.tuia.treasure.center.api.dto.VideoDto;
import cn.tuia.tuia.treasure.center.api.remoteservice.fallback.RemoteTreasureServiceFallback;

import java.util.List;

/**
 * Created by zhou_wb on 2018/4/23.
 */
@AdvancedFeignClient(fallback = RemoteTreasureServiceFallback.class)
public interface RemoteTreasureService {
    /**
     * 查询置顶内容类表
     */
    List<StickContentDto> selectStickContents();

    /**
     * 批量更新、插入置顶内容
     * @param stickContentDtos stickContentDtos
     */
    Boolean batchSave(List<StickContentDto> stickContentDtos);

    /**
     * 根据请求参数，返回合适的推荐内容
     * @param expectDto 请求内容
     * @return 推荐内容
     */
    RecomeDto getRecomeContent(ExpectDto expectDto);


    /**
     * 根据标签id，返回合适的推荐内容
     * @param expectDto 请求内容
     * @return 推荐内容
     */
    RecomeDto getRecomeContentByTagId(ExpectDto expectDto);


    /**
     * 根据标签id，返回合适的推荐内容（对外使用）
     * @param expectOutDto 请求内容
     * @return 推荐内容
     */
    RecomeDto getRecomeContentByTagIdForOut(ExpectOutDto expectOutDto);


    /**
     * 根据标签id，返回合适的推荐内容(为了ios过审核使用！！！！！！！！！！！！！！！！)
     * @param expectDto 请求内容
     * @return 推荐内容
     */
    RecomeDto getRecomeContentByTagIdForIos(ExpectDto expectDto);


}
