package cn.tuia.tuia.treasure.center.api.enums;

/**
 * 这里兼容美拍逻辑所以没有从1开始
 */
public enum VideoTagEnum {
    MUSIC(1001L, "音乐"),
    DANCE(1039L, "舞蹈"),
    PERFORMANCE(1084L, "表演"),
    TALENT(1085L, "才艺"),
    SELFIE(1089L, "自拍"),
    PET(1090L, "宠物"),
    FOOD(1092L, "美食"),
    EAT_SHOW(1093L, "吃秀"),
    NEWS(1101L, "新闻"),
    OTHER(1103L, "其他"),
    CREATIVE(1100L, "创意"),
    //文档上1097是 涨姿势
    UP_POSTURE(1097L, "生活百科"),
    GAME(1083L, "游戏"),
    MAKEUPS(1086L, "美妆"),
    SPORTS(1088L, "运动"),
    BABY(1091L, "宝宝"),
    MANUAL(1094L, "手工"),
    TRAVEL(1095L, "旅行"),
    TOY(1096L, "玩具"),
    MOVIE(1098L, "影视"),
    STAR(1099L, "明星"),
    TECHNOLOGY(1102L, "科技人文"),
    FASHION(1087L, "时尚"),

    SQUARE_DANCE(1L, "广场舞"),
    CAR(2L, "汽车"),
    FUNNY(3L, "搞笑"),

    //百度新增
    RECOMMEND(4L, "推荐"),
    SOCIETY(5L, "社会"),
    ;
    private Long code;
    private String desc;

    VideoTagEnum(Long code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Long getCode() {
        return code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static VideoTagEnum getByCode(Long code) {
        for (VideoTagEnum value : VideoTagEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }

    public static VideoTagEnum getByDesc(String desc) {
        for (VideoTagEnum value : VideoTagEnum.values()) {
            if (value.getDesc().equals(desc)) {
                return value;
            }
        }
        return null;
    }
}
