/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.youtui.center.api.constant.youtui;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum GameVersion {
    DISTRIBUTION1(1, "1.1", "\u7248\u672c\u8bf4\u660e\uff1a\u662f\u5426\u7ee7\u7eed\u5012\u8ba1\u65f6\u7248"),
    CHICKEN1(2, "1.3", "\u7248\u672c\u8bf4\u660e\uff1a\u5206\u4eab\u5230\u8da3\u6652\u83b7\u53d6\u5fae\u4fe1\u7528\u6237\u4fe1\u606f\u7248");

    private Integer code;
    private String version;
    private String desc;

    private GameVersion(Integer code, String version, String desc) {
        this.code = code;
        this.version = version;
        this.desc = desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Map<String, String> getGameVersionMap(Integer gameTypeCode) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        List<GameVersion> list = Arrays.stream(GameVersion.values()).filter(v -> v.getCode() == gameTypeCode).sorted((p1, p2) -> p2.getVersion().compareTo(p1.getVersion())).collect(Collectors.toList());
        list.forEach(one -> result.put(one.getVersion(), one.getDesc()));
        return result;
    }

    public static void main(String[] args) {
        Map<String, String> a = GameVersion.getGameVersionMap(2);
        for (String b : a.values()) {
            System.out.println(b);
        }
    }
}

