package cn.com.duiba.tuia.youtui.center.api.constant.youtui;

import com.alibaba.fastjson.JSON;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 内容类型
 * Created by xuefeng on 2018/5/18.
 */
public enum ContentType {

    Activity(1, "活动"),
    Direct(2,"直投页"),
    Mission(3,"任务"),
    Context(4,"外部内容"),
    Game(5,"游戏"),
    ;

    private Integer type;
    private String content;

    ContentType(Integer type, String content) {
        this.type = type;
        this.content = content;
    }

    public Integer getType() {
        return type;
    }

    public String getContent() {
        return content;
    }

    public static Map<String, Integer> getContentTypeMap() {
        return Arrays.stream(ContentType.values()).collect(Collectors.toMap(ContentType::getContent, ContentType::getType));
    }

    public static void main(String[] args) {
        Map<String, Integer> a = getContentTypeMap();
        System.out.println(JSON.toJSON(a));
    }
}
