package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiOperationsPositionDto;

import java.util.List;

/**
 * 运营位管理remote业务
 * @author liyuanzeng 2018/7/30
 */
@AdvancedFeignClient
public interface RemoteYoutuiOperationsPositionService {

    PageDto<YoutuiOperationsPositionDto> selectPageList(Integer offset, Integer max);

    YoutuiOperationsPositionDto selectById(Long id);

    int insert(YoutuiOperationsPositionDto operationsPositionDto);

    int update(YoutuiOperationsPositionDto operationsPositionDto);

    int deleteById(Long id);

    /**
     * 内容是否存在于运营位
     *
     * @param contextType
     * @param contextId
     * @return
     */
    Boolean isExsit(Integer contextType, Long contextId);

    /**
     * 根据内容类型 获取相应内容的ids
     * @param contextType
     * @return
     */
    List<Long> selectContentIdsByContentType(Integer contextType);
}
