package cn.com.duiba.tuia.youtui.center.api.dto.youtui;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 微信分享样式配置
 */
@ApiModel("微信分享样式配置")
public class WechatPutConfigDto extends BaseContentPutConfig {
    /**
     * 分享内容（1：图文；2：图片）
     */
    @ApiModelProperty(value = "分享内容（1：图文；2：图片）", dataType = "Integer")
    private Integer shareContentType;

    /**
     * 二维码坐标对象
     */
    @ApiModelProperty(value = "二维码坐标对象", dataType = "QRCodePoint")
    private QRCodePoint qRCodePoint;

    @ApiModelProperty(value = "分享链接", dataType = "String")
    private String shareUrl;

    public Integer getShareContentType() {
        return shareContentType;
    }

    public void setShareContentType(Integer shareContentType) {
        this.shareContentType = shareContentType;
    }


    public String getShareUrl() {
        return shareUrl;
    }

    public void setShareUrl(String shareUrl) {
        this.shareUrl = shareUrl;
    }

    public QRCodePoint getqRCodePoint() {
        return qRCodePoint;
    }

    public void setqRCodePoint(QRCodePoint qRCodePoint) {
        this.qRCodePoint = qRCodePoint;
    }

    public static void main(String[] args) {
        WechatPutConfigDto wechatPutConfigDto = new WechatPutConfigDto();
        wechatPutConfigDto.setImgUrl("http://werqq21/123213");
        wechatPutConfigDto.setDesc("desc");
        wechatPutConfigDto.setTitle("title");
        wechatPutConfigDto.setShareContentType(2);
        wechatPutConfigDto.setqRCodePoint(new QRCodePoint(10,10,10,10));
        wechatPutConfigDto.setShareUrl("http://share/uwercd");
        System.err.println(JSON.toJSONString(wechatPutConfigDto));
    }

    /**
     * 二维码四角坐标
     */
    @ApiModel("二维码四角坐标")
    public static class QRCodePoint implements Serializable{

        /**
         * 左上角
         */
        @ApiModelProperty(value = "左上角X", dataType = "Integer")
        private Integer leftTopX;

        /**
         * 左上角
         */
        @ApiModelProperty(value = "左上角Y", dataType = "Integer")
        private Integer leftTopY;

        @ApiModelProperty(value = "二维码长度", dataType = "Integer")
        private Integer width;

        @ApiModelProperty(value = "二维码宽度", dataType = "Integer")
        private Integer height;

        public QRCodePoint() {
        }

        public QRCodePoint(Integer leftTopX, Integer leftTopY, Integer width, Integer height) {
            this.leftTopX = leftTopX;
            this.leftTopY = leftTopY;
            this.width = width;
            this.height = height;
        }

        public Integer getLeftTopX() {
            return leftTopX;
        }

        public void setLeftTopX(Integer leftTopX) {
            this.leftTopX = leftTopX;
        }

        public Integer getLeftTopY() {
            return leftTopY;
        }

        public void setLeftTopY(Integer leftTopY) {
            this.leftTopY = leftTopY;
        }

        public Integer getWidth() {
            return width;
        }

        public void setWidth(Integer width) {
            this.width = width;
        }

        public Integer getHeight() {
            return height;
        }

        public void setHeight(Integer height) {
            this.height = height;
        }
    }
}
