package cn.com.duiba.tuia.youtui.center.api.constant.youtui;

import com.alibaba.fastjson.JSON;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 游戏版本
 * @author liyuanzeng 2018/7/27
 */
public enum GameVersion {

    DISTRIBUTION1(1, "1.1", "版本说明：是否继续倒计时版"),
    CHICKEN1(2, "1.3", "版本说明：分享到趣晒获取微信用户信息版");

    private Integer code;
    private String version;
    private String desc;

    GameVersion(Integer code, String version, String desc) {
        this.code = code;
        this.version = version;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Map<String, String> getGameVersionMap(Integer gameTypeCode) {
        return Arrays.stream(GameVersion.values()).filter(v -> v.getCode() == gameTypeCode).collect(Collectors.toMap(GameVersion::getVersion, GameVersion::getDesc));
    }

    public static void main(String[] args) {
        Map<String, String> a = getGameVersionMap(2);
        System.out.println(JSON.toJSON(a));
    }
}


