package cn.com.duiba.tuia.youtui.center.api.dto.rsp;

import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiPutConfigDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;


/**
 * Created by xuefeng on 2018/5/21.
 */
@ApiModel("分享内容列表")
public class ContentStaticRsp implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 推广计划id **/
    @ApiModelProperty( value = "推广计划ID",dataType = "Long")
    private Long cyapId;

    /** 分享次数 **/
    @ApiModelProperty(value = "分享次数(PV)",dataType = "Long")
    private Long shareTime;

    /** 累计金额 **/
    @ApiModelProperty(value = "累积金额",dataType = "Long")
    private Long amount;

    /** 内容id **/
    @ApiModelProperty(value = "内容ID",dataType = "Long")
    private Long contentId;

    /** 内容类型 1.活动 **/
    @ApiModelProperty(value = "内容类型(1:活动；2:直投页；3:任务；4:游戏)",dataType = "Integer")
    private Integer contentType;

    /** title:活动标题. */
    @ApiModelProperty(value = "标题（app内卡片），1.3.0移至youtuiPutConfigDto中",dataType = "String")
    private String title;

    /** title:活动副标题. */
    @ApiModelProperty(value = "副标题（app内卡片），1.3.0移至youtuiPutConfigDto中",dataType = "String")
    private String subTitle;

    /** app内展示的素材图片. */
    @ApiModelProperty(value = "图片（app内卡片），1.3.0移至youtuiPutConfigDto中",dataType = "String")
    private String appMaterialImg;

    /** app内玩法说明图片. */
    @ApiModelProperty(value = "玩法说明图片（app内卡片）,1.1.03版本已废弃",dataType = "Srting")
    private String appInstructionImg;

    /** 玩法说明 */
    @ApiModelProperty(value = "玩法说明（app内卡片）,1.1.03版本已废弃",dataType = "Srting")
    private String instruction;

    /** 是否已分享 **/
    @ApiModelProperty(value = "是否已分享",dataType = "Boolean")
    private Boolean isShared = false;

    /** 是否被置顶 **/
    @ApiModelProperty(value = "置顶时间戳（不置顶时为空）",dataType = "Long")
    private Long isTopSort;

    /** 分享人数(人) **/
    @ApiModelProperty(value = "分享人数(UV)",dataType = "Long")
    private Long shareManNum;

    /** 平均金额 **/
    @ApiModelProperty(value = "平均收益(分)",dataType = "Long")
    private Long avgAmount;

    /** 微信分享快照图片. */
    @ApiModelProperty(value = "微信分享快照图片(废弃)")
    private String wxSnapshotImg;

    /** 内容中心提供的url */
    @ApiModelProperty(value = "内容URL（pangu-web），1.3.0以后的版本可以废弃")
    private String contextUrl;

    /** 预览url **/
    @ApiModelProperty(value = "预览URL",dataType = "String")
    private String previewUrl;

    public Long getIsTopSort() {
        return isTopSort;
    }

    public void setIsTopSort(Long isTopSort) {
        this.isTopSort = isTopSort;
    }

    public Long getShareTime() {
        return shareTime;
    }

    public void setShareTime(Long shareTime) {
        this.shareTime = shareTime;
    }

    public Long getAmount() {
        return amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Long getContentId() {
        return contentId;
    }

    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    public Integer getContentType() {
        return contentType;
    }

    public void setContentType(Integer contentType) {
        this.contentType = contentType;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubTitle() {
        return subTitle;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public String getAppMaterialImg() {
        return appMaterialImg;
    }

    public void setAppMaterialImg(String appMaterialImg) {
        this.appMaterialImg = appMaterialImg;
    }

    public String getAppInstructionImg() {
        return appInstructionImg;
    }

    public void setAppInstructionImg(String appInstructionImg) {
        this.appInstructionImg = appInstructionImg;
    }

    public String getInstruction() {
        return instruction;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public Boolean getShared() {
        return isShared;
    }

    public void setShared(Boolean shared) {
        isShared = shared;
    }

    public Long getCyapId() {
        return cyapId;
    }

    public void setCyapId(Long cyapId) {
        this.cyapId = cyapId;
    }

    public Long getShareManNum() {
        return shareManNum;
    }

    public void setShareManNum(Long shareManNum) {
        this.shareManNum = shareManNum;
    }

    public Long getAvgAmount() {
        return avgAmount;
    }

    public void setAvgAmount(Long avgAmount) {
        this.avgAmount = avgAmount;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    public String getWxSnapshotImg() {
        return wxSnapshotImg;
    }

    public void setWxSnapshotImg(String wxSnapshotImg) {
        this.wxSnapshotImg = wxSnapshotImg;
    }

    public String getContextUrl() {
        return contextUrl;
    }

    public void setContextUrl(String contextUrl) {
        this.contextUrl = contextUrl;
    }

    public static int compareThis(ContentStaticRsp contentStaticRsp1, ContentStaticRsp contentStaticRsp2) {
        if(0 == contentStaticRsp1.getIsTopSort() && 0 == contentStaticRsp2.getIsTopSort()){
            if (contentStaticRsp1.getShareTime().intValue() == contentStaticRsp2.getShareTime().intValue()) {
                return contentStaticRsp2.getAmount().intValue() - contentStaticRsp1.getAmount().intValue();
            } else {
                return contentStaticRsp2.getShareTime().intValue() - contentStaticRsp1.getShareTime().intValue();
            }
        }else if(0 != contentStaticRsp1.getIsTopSort() && 0 != contentStaticRsp2.getIsTopSort()){
            return contentStaticRsp2.getIsTopSort().intValue() - contentStaticRsp1.getIsTopSort().intValue();
        }else if(0 != contentStaticRsp1.getIsTopSort()){
            return -1;
        }else if(0 != contentStaticRsp2.getIsTopSort()){
            return 1;
        }
        return 0;
    }
}
