package cn.com.duiba.tuia.youtui.center.api.dto.youtui;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 微信分享样式配置
 */
@ApiModel("微信分享样式配置")
public class WechatPutConfigDto extends BaseContentPutConfig {
    /**
     * 分享内容（1：图文；2：图片）
     */
    @ApiModelProperty(value = "分享内容（1：图文；2：图片）", dataType = "Integer")
    private Integer shareContentType;

    /**
     * 二维码坐标对象
     */
    @ApiModelProperty(value = "二维码坐标对象", dataType = "QRCodePoint")
    private QRCodePoint qRCodePoint;

    /**
     * 开关状态(默认开启)
     */
    @ApiModelProperty(value = "开关状态(默认开启),0:未开启；1:开启", dataType = "Integer")
    private Integer openStatus;

    public WechatPutConfigDto() {
        this.openStatus = 1;
    }

    public Integer getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(Integer openStatus) {
        this.openStatus = openStatus;
    }

    public Integer getShareContentType() {
        return shareContentType;
    }

    public void setShareContentType(Integer shareContentType) {
        this.shareContentType = shareContentType;
    }

    public QRCodePoint getqRCodePoint() {
        return qRCodePoint;
    }

    public void setqRCodePoint(QRCodePoint qRCodePoint) {
        this.qRCodePoint = qRCodePoint;
    }

    /**
     * 二维码四角坐标
     */
    @ApiModel("二维码四角坐标")
    public static class QRCodePoint {

        /**
         * 左上角
         */
        @ApiModelProperty(value = "左上角", dataType = "Integer")
        private Integer leftTop;

        /**
         * 右上角
         */
        @ApiModelProperty(value = "右上角", dataType = "Integer")
        private Integer rightTop;

        /**
         * 左下角
         */
        @ApiModelProperty(value = "左下角", dataType = "Integer")
        private Integer leftDown;

        /**
         * 右下角
         */
        @ApiModelProperty(value = "右下角", dataType = "Integer")
        private Integer rightDown;

        public QRCodePoint() {
        }

        public QRCodePoint(Integer leftTop, Integer rightTop, Integer leftDown, Integer rightDown) {
            this.leftTop = leftTop;
            this.rightTop = rightTop;
            this.leftDown = leftDown;
            this.rightDown = rightDown;
        }

        public Integer getLeftTop() {
            return leftTop;
        }

        public void setLeftTop(Integer leftTop) {
            this.leftTop = leftTop;
        }

        public Integer getRightTop() {
            return rightTop;
        }

        public void setRightTop(Integer rightTop) {
            this.rightTop = rightTop;
        }

        public Integer getLeftDown() {
            return leftDown;
        }

        public void setLeftDown(Integer leftDown) {
            this.leftDown = leftDown;
        }

        public Integer getRightDown() {
            return rightDown;
        }

        public void setRightDown(Integer rightDown) {
            this.rightDown = rightDown;
        }
    }
}
