package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.MissionDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.MissionRecordDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.MissionRecordMoneyDto;

import java.util.List;

/**
 *  活动中心的service
 *  @author lichao 2018/6/28
 */
@AdvancedFeignClient
public interface RemoteMissionService {

    /**
     * 查询所有任务
     * @return
     */
    List<MissionDto> findAllMission();

    /**
     * 查询所有的完成的任务
     * @return
     */
    List<MissionRecordDto> findAllMissionRecord(Long consumerId);


    /**
     * 完成任务
     * @param mission 任务id
     * @param consumerId 用户id
     * @return
     */
    boolean completeMission(MissionDto mission,Long consumerId);

    /**
     * 根据条件查询任务
     * @param recordDto
     * @return
     */
    List<MissionRecordDto> findRecordSective(MissionRecordDto recordDto);

    /**
     * 根据条件查询总额
     * @param recordDto
     * @return
     */
    List<MissionRecordMoneyDto> findRecrdAmount(MissionRecordDto recordDto);



}
