package cn.com.duiba.tuia.youtui.center.api.constant;

public enum QBDenomination {
    ONE(1, "50001"),
    FIVE(5, "50002"),
    TWENTY(20, "50003"),
    THIRTY(30, "50004"),
    FIFTY(50, "50005"),
    HUNDRED(100, "50006"),;


    private Integer price;
    private String proId;

    public String getProId() {
        return proId;
    }

    public Integer getPrice() {
        return price;
    }

    QBDenomination(Integer price, String proId) {
        this.price = price;
        this.proId = proId;
    }


    public static QBDenomination get(Integer amount) {
        for (QBDenomination qbDenomination : QBDenomination.values()) {
            if (amount % qbDenomination.price == 0 && amount / qbDenomination.price <= 10) {
                return qbDenomination;
            }
        }
        throw new QBDenominationNotExistException();
    }

    private static class QBDenominationNotExistException extends RuntimeException {
        QBDenominationNotExistException() {
            super("不存在合适的面额");
        }
    }

}
