package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.ActivityType;
import cn.com.duiba.tuia.youtui.center.api.dto.req.YoutuiActivityReq;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiActivityManageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiOptionDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiSkinDataDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiSkinTemplateDto;

import java.util.List;

/**
 * 活动管理后台
 * Create by yuanwei
 * at 2018/6/27 0027 下午 15:14
 */
@AdvancedFeignClient
public interface RemoteActivityManageService  {
    /**
     *id查询活动
     * @param id
     * @return
     */
    YoutuiActivityManageDto queryActivity(Long id);

    /**
     * ids批量查询活动
     * @param ids
     * @return
     */
    List<YoutuiActivityManageDto> queryActivityList(List<Long> ids);

    /**
     * 条件分页查询活动
     * @param youtuiActivityReq
     * @return
     */
    PageDto<YoutuiActivityManageDto> selectPageActivitys(YoutuiActivityReq youtuiActivityReq);
    /**
     * selectAllActivityType:(查询所有的活动类型). <br/>
     *
     * @return Integer:String 活动类型：活动类型名称
     * @author wubo
     * @since JDK 1.7
     */
    List<ActivityType> selectAllActivityType();

    List<YoutuiSkinTemplateDto> selectSkinTemplateByTemplateType(Integer templateType);

    YoutuiSkinTemplateDto selectSkinTemplateDetailBySkinType(String skinType);

    Boolean updateActivitySkinDataByActivityId(Long activityId,String dataJson);

    /**
     * 保存活动
     * @param dto
     * @return
     */
    Long saveActivity(YoutuiActivityManageDto dto);

    Long insertActivitySkin(YoutuiSkinDataDto dto);

    /**
     * 批量保存活动奖项
     * @param list
     * @return
     */
    int saveActivityOption(List<YoutuiOptionDto> list);

    /**
     * 批量删除活动奖项
     * @param ids
     * @return
     */
    Long deleteActivityOption(List<Long> ids);

    /**
     * 删除活动
     * @param id
     * @return
     */
    int deleteActivity(Long id);

    List<YoutuiOptionDto> selectOptionByActivityId(Long activityId);

    YoutuiSkinDataDto selectActivitySkinByActivityId(Long activityId);

    PageDto<YoutuiSkinTemplateDto> selectSkinTemplateByPage(Integer offset, Integer max);

    Long saveSkinTemplate(YoutuiSkinTemplateDto dto);

}
