package cn.com.duiba.tuia.youtui.center.api.cache;

import java.util.concurrent.TimeUnit;

/**
 * ClassName: CacheSpace <br/>
 * Function: 缓存枚举. <br/>
 * Reason: 配置方便. <br/>
 * Attention:注释必须注明缓存的业务，参数维度，缓存的类，不注明者死全家!
 * 缓存key=TAC-key-参数...
 * date: 2017年1月19日 下午8:49:44 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public enum CacheSpace {


    /**
     * 友推用户余额
     */
    YOUTUI_USER_BALANCE("55", 20, TimeUnit.MINUTES),

    /**
     * 友推用户余额
     */
    YOUTUI_USER_YESTERDAY_INCOME("56", 20, TimeUnit.MINUTES),

    /** key每次+1，缓存时间根据实际情况制定.*/
    SIMPLE("n++",1,TimeUnit.DAYS);



    private static final String SPACE = "TAC";

    /**
     * 缓存key标识 缓存key=TAC-key标识-参数 注意:key不允许重复
     */
    private String              key;

    /**
     * 缓存时间
     */
    private int                 time;

    /**
     * 时间单位
     */
    private TimeUnit            unit;

    CacheSpace(String key, int time, TimeUnit unit) {
        this.key = key;
        this.time = time;
        this.unit = unit;
    }

    public String getKey() {
        return key;
    }

    public int getTime() {
        return time;
    }

    public TimeUnit getUnit() {
        return unit;
    }

    public String generatorKey(Object... params) {
        StringBuilder sb = new StringBuilder(SPACE + "-");
        sb.append(key);
        if (params != null) {
            for (Object temp : params) {
                sb.append("-");
                sb.append(temp);
            }
        }

        return sb.toString();
    }
}
