package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.req.ReqHotAirticle;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiHotAirticleDto;

import java.util.List;

/**
 * Create by yuanwei
 * at 2018/8/14 0014 下午 17:40
 */
@AdvancedFeignClient
public interface RemoteHotAirticleService {

    /**
     * 查询热文列表
     * @param req
     * @return
     */
    PageDto<YoutuiHotAirticleDto> selectHotAirticleList(ReqHotAirticle req);

    /**
     * 通过id查询热文详情
     * @param id
     * @return
     */
    YoutuiHotAirticleDto selectHotAirticById(Long id);

    /**
     * 通过id删除热文
     * @param id
     * @return
     */
    int deleteHotAirticleById(Long id);

    /**
     * 新增热文
     * @param dto
     * @return
     */
    Long insertHotAirticle(YoutuiHotAirticleDto dto);

    /**
     * 修改热文
     * @param dto
     * @return
     */
    Long updateHotAirticle(YoutuiHotAirticleDto dto);

    /**
     * 上下线热文
     * @param id
     * @return
     */
    Long upDownLineHotAirticle(Long id,Integer isPublish);

    /**
     * 推荐或者取消推荐热文
     * @return
     */
    Long recommendHotAirticleOrNot(Long id,Integer isRecommend );

    /**
     * 批量插入热文
     * @param dtos
     * @return
     */
    int batchInsert(List<YoutuiHotAirticleDto> dtos);

}
