package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.req.ReqLandPageQuery;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiLandPageDto;

/**
 * Create by yuanwei
 * at 2018/8/14 0014 上午 9:50
 */
@AdvancedFeignClient
public interface RemoteLandPageManagerService {
    /**
     * 查询落地页表格数据
     * @param req
     * @return
     */
    PageDto<YoutuiLandPageDto> selectLandPageList(ReqLandPageQuery req);

    /**
     * 通过id查询落地页详情
     * @param id
     * @return
     */
    YoutuiLandPageDto selectLandPageDetail(Long id);

    /**
     * 删除落地页
     * @param id
     * @return
     */
    int deleteLandPage(Long id);

    /**
     * 新增落地页
     * @param dto
     * @return
     */
    Long insertLandPage(YoutuiLandPageDto dto);

    /**
     * 修改落地页
     * @param dto
     * @return
     */
    Long updateLandPage(YoutuiLandPageDto dto);
}
