package cn.com.duiba.tuia.youtui.center.api.dto.push;

public enum PushUrlType {
    H5(1, "h5"),
    YUANSHENG(2, "原生");

    private int code;

    private String desc;

    PushUrlType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static PushUrlType getPushUrlType(int code) {
        for (PushUrlType e : PushUrlType.values()) {
            if (e.code == code) {
                return e;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
