package cn.com.duiba.tuia.youtui.center.api.dto.youtui;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 *回流创意-回流奖励dto
 */
@ApiModel("回流奖励配置")
public class RefluxRewardConfigDto implements Serializable {

    private static final long serialVersionUID = 8314002408232191972L;

    /**
     * 场景标识
     */
    @ApiModelProperty(value = "场景标识", dataType = "String")
    private String sceneTitle;

    /**
     * 回流奖励内容
     */
    @ApiModelProperty(value = "回流奖励内容", dataType = "RefluxRewardContent")
    List<RefluxRewardContent> refluxRewardContents;

    public String getSceneTitle() {
        return sceneTitle;
    }

    public void setSceneTitle(String sceneTitle) {
        this.sceneTitle = sceneTitle;
    }

    public List<RefluxRewardContent> getRefluxRewardContents() {
        return refluxRewardContents;
    }

    public void setRefluxRewardContents(List<RefluxRewardContent> refluxRewardContents) {
        this.refluxRewardContents = refluxRewardContents;
    }

    /**
     * 回流创意-回流奖励内容
     */
    @ApiModel("回流奖励内容")
    public static class RefluxRewardContent extends BaseRatioDto  implements Serializable {

        private static final long serialVersionUID = 2524430564723337486L;
        /**
         * 奖励金额
         */
        @ApiModelProperty(value = "奖励金额", dataType = "String")
        private String rewardNum;

        /**
         * 提现额度
         */
        @ApiModelProperty(value = "提现额度", dataType = "String")
        private String cashNum;

        public String getRewardNum() {
            return rewardNum;
        }

        public void setRewardNum(String rewardNum) {
            this.rewardNum = rewardNum;
        }

        public String getCashNum() {
            return cashNum;
        }

        public void setCashNum(String cashNum) {
            this.cashNum = cashNum;
        }
    }
}
