package cn.com.duiba.tuia.youtui.center.api.dto.youtui;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 极限手速游戏配置dto
 */
@ApiModel("极限手速游戏配置")
public class ExtremeHandSpeedConfigDto extends RuleConfigDto implements Serializable {

    private static final long serialVersionUID = 6134123055022270433L;
    /**
     * 奖励金额上限
     */
    @ApiModelProperty(value = "奖励金额上限", dataType = "Double")
    private Double rewardMax;

    /**
     * 翻倍一次获得金额
     */
    @ApiModelProperty(value = "翻倍一次获得金额", dataType = "Double")
    private Double singleReward;

    /**
     * 奖励设置
     */
    @ApiModelProperty(value = "奖励设置", dataType = "List<ExtremeHandSpeedSetting>")
    private List<ExtremeHandSpeedSetting> rewardSettings = new ArrayList<>();

    public ExtremeHandSpeedConfigDto() {
        rewardSettings.add(new ExtremeHandSpeedSetting(1, "3*3", 0.5, 60, 100));
        rewardSettings.add(new ExtremeHandSpeedSetting(2, "4*4", 0.6, 60, 100));
        rewardSettings.add(new ExtremeHandSpeedSetting(3, "5*5", 0.8, 60, 100));
        rewardSettings.add(new ExtremeHandSpeedSetting(4, "6*6", 0.8, 60, 100));
        rewardSettings.add(new ExtremeHandSpeedSetting(5, "7*7", 0.8, 60, 100));
        rewardSettings.add(new ExtremeHandSpeedSetting(6, "8*8", 0.9, 60, 100));
        rewardSettings.add(new ExtremeHandSpeedSetting(7, "9*9", 0.9, 60, 100));
    }

    public Double getRewardMax() {
        return rewardMax;
    }

    public void setRewardMax(Double rewardMax) {
        this.rewardMax = rewardMax;
    }

    public Double getSingleReward() {
        return singleReward;
    }

    public void setSingleReward(Double singleReward) {
        this.singleReward = singleReward;
    }

    public List<ExtremeHandSpeedSetting> getRewardSettings() {
        return rewardSettings;
    }

    public void setRewardSettings(List<ExtremeHandSpeedSetting> rewardSettings) {
        this.rewardSettings = rewardSettings;
    }
}
