package cn.com.duiba.tuia.youtui.center.api.dto.youtui;

import cn.com.duiba.tuia.youtui.center.api.util.RandomFlowUtil;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 趣晒内容投放配置Dto
 */
@ApiModel("投放配置")
public class YoutuiPutConfigDto extends RuleConfigDto implements Serializable {

    @ApiModelProperty(value = "投放配置ID", dataType = "Long")
    private Long id;

    /**
     * 内容ID
     */
    @ApiModelProperty(value = "投放内容ID", dataType = "Long")
    private Long contentId;

    /**
     * 内容类型
     */
    @ApiModelProperty(value = "投放内容类型(1:活动；2:直投页；3:任务；4:游戏)", dataType = "Integer")
    private Integer contentType;

    /**
     * 内容投放格式配置
     */
    @ApiModelProperty(value = "投放内容格式配置", dataType = "ContentPutConfig")
    private ContentPutConfig cpConfig;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getContentId() {
        return contentId;
    }

    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    public Integer getContentType() {
        return contentType;
    }

    public void setContentType(Integer contentType) {
        this.contentType = contentType;
    }

    public ContentPutConfig getCpConfig() {
        return cpConfig;
    }

    public void setCpConfig(ContentPutConfig cpConfig) {
        this.cpConfig = cpConfig;
    }

    /**
     * 内容投放格式配置
     */
    @ApiModel("投放内容格式配置")
    public static class ContentPutConfig implements Serializable {

        @ApiModelProperty(value = "平均收益基准值", dataType = "Long")
        private Long avgIncome;
        @ApiModelProperty(value = "奖励金额",dataType = "Long")
        private Long rewardAmount;
        @ApiModelProperty(value = "奖励方式",dataType = "Integer")
        private Integer rewardType;
        @ApiModelProperty(value = "热文内大图",dataType = "String")
        private String bigImgUrl;

        /**
         * app客户端投放配置
         */
        @ApiModelProperty(value = "客户端内展示配置", dataType = "List<AppClientPutConfigDto>")
        private List<AppClientPutConfigDto> acpcDtos;

        /**
         * 微信一级分享配置
         */
        @ApiModelProperty(value = "微信一级分享展示配置", dataType = "List<WechatPutConfigDto>")
        private List<WechatPutConfigDto> wcpcFirstDtos;

        /**
         * 开关状态(默认开启)
         */
        @ApiModelProperty(value = "微信次级分享配置开关状态(默认开启),0:未开启；1:开启", dataType = "Integer")
        private Integer openStatus;

        /**
         * 微信次级分享配置
         */
        @ApiModelProperty(value = "微信次级分享配置", dataType = "List<WechatPutConfigDto>")
        private List<WechatPutConfigDto> wcpcNextDtos;

        /**
         * 回流创意 - 奖励内容类型（1：现金奖励；）
         */
        @ApiModelProperty(value = "奖励内容", dataType = "Integer")
        private Integer rewardContentType;

        /**
         * 回流创意 - 回流素材配置
         */
        @ApiModelProperty(value = "回流素材", dataType = "List<RefluxPutConfigDto>")
        private List<RefluxPutConfigDto> refluxPutConfigDtos;

        /**
         * 回流创意 - 回流奖励配置
         */
        @ApiModelProperty(value = "奖励内容", dataType = "List<RefluxRewardConfigDto>")
        private List<RefluxRewardConfigDto> refluxRewardConfigDtos;

        public String getBigImgUrl() {
            return bigImgUrl;
        }

        public void setBigImgUrl(String bigImgUrl) {
            this.bigImgUrl = bigImgUrl;
        }

        public Long getRewardAmount() {
            return rewardAmount;
        }

        public void setRewardAmount(Long rewardAmount) {
            this.rewardAmount = rewardAmount;
        }

        public Integer getRewardType() {
            return rewardType;
        }

        public void setRewardType(Integer rewardType) {
            this.rewardType = rewardType;
        }

        public Integer getOpenStatus() {
            return openStatus;
        }

        public void setOpenStatus(Integer openStatus) {
            this.openStatus = openStatus;
        }

        public Long getAvgIncome() {
            return avgIncome;
        }

        public void setAvgIncome(Long avgIncome) {
            this.avgIncome = avgIncome;
        }

        public List<AppClientPutConfigDto> getAcpcDtos() {
            return acpcDtos;
        }

        public void setAcpcDtos(List<AppClientPutConfigDto> acpcDtos) {
            this.acpcDtos = acpcDtos;
        }

        public List<WechatPutConfigDto> getWcpcFirstDtos() {
            return wcpcFirstDtos;
        }

        public void setWcpcFirstDtos(List<WechatPutConfigDto> wcpcFirstDtos) {
            this.wcpcFirstDtos = wcpcFirstDtos;
        }

        public List<WechatPutConfigDto> getWcpcNextDtos() {
            return wcpcNextDtos;
        }

        public void setWcpcNextDtos(List<WechatPutConfigDto> wcpcNextDtos) {
            this.wcpcNextDtos = wcpcNextDtos;
        }

        public Integer getRewardContentType() {
            return rewardContentType;
        }

        public void setRewardContentType(Integer rewardContentType) {
            this.rewardContentType = rewardContentType;
        }

        public List<RefluxPutConfigDto> getRefluxPutConfigDtos() {
            return refluxPutConfigDtos;
        }

        public void setRefluxPutConfigDtos(List<RefluxPutConfigDto> refluxPutConfigDtos) {
            this.refluxPutConfigDtos = refluxPutConfigDtos;
        }

        public List<RefluxRewardConfigDto> getRefluxRewardConfigDtos() {
            return refluxRewardConfigDtos;
        }

        public void setRefluxRewardConfigDtos(List<RefluxRewardConfigDto> refluxRewardConfigDtos) {
            this.refluxRewardConfigDtos = refluxRewardConfigDtos;
        }

        /**
         * 根据用户按概率获取客户端配置
         *
         * @param userId
         * @return
         */
        public AppClientPutConfigDto findAcpcByUserIdRatio(Long userId) {
            Integer index = RandomFlowUtil.computeIndexById(userId, this.acpcDtos);
            return this.acpcDtos.get(index);
        }

        /**
         * 按照概率获取客户端配置
         *
         * @return
         */
        public AppClientPutConfigDto findAcpcByRatio() {
            Integer index = RandomFlowUtil.computeIndex(this.acpcDtos);
            return this.acpcDtos.get(index);
        }

        /**
         * 客户端内容用户分享分流（按用户）
         *
         * @param userId
         * @return
         */
        public WechatPutConfigDto findWXPcFirstByUserIdRatio(Long userId) {
            Integer index = RandomFlowUtil.computeIndexById(userId, this.wcpcFirstDtos);
            return this.wcpcFirstDtos.get(index);
        }

        /**
         * 客户端内容用户分享分流（按用户，剔除图片模式）
         *
         * @param userId
         * @return
         */
        public WechatPutConfigDto findWXPcFirstByUserIdRatioWithOutPicture(Long userId) {
            List<WechatPutConfigDto> wcpcDtos = this.wcpcFirstDtos.stream().filter(dto -> dto.getShareContentType() != 1).collect(Collectors.toList());
            Integer index = RandomFlowUtil.computeIndexById(userId, wcpcDtos);
            return wcpcDtos.get(index);
        }

        /**
         * 客户端内容用户分享分流（按概率）
         *
         * @return
         */
        public WechatPutConfigDto findWXPcFirstByRatio() {
            Integer index = RandomFlowUtil.computeIndex(this.wcpcFirstDtos);
            return this.wcpcFirstDtos.get(index);
        }


        /**
         * 按照概率随机获取刺激分享配置
         *
         * @return
         */
        public WechatPutConfigDto findWXPcNextByRatio() {
            Integer index = RandomFlowUtil.computeIndex(this.wcpcNextDtos);
            return this.wcpcNextDtos.get(index);
        }

        /**
         * 按照概率随机获取次级分享配置（按用户，剔除图片模式）
         *
         * @return
         */
        public WechatPutConfigDto findWXPcNextByUserIdRatio(Long userId) {
            List<WechatPutConfigDto> wechatPutConfigDtos = this.wcpcNextDtos.stream().filter(dto -> dto.getShareContentType() != 1).collect(Collectors.toList());
            Integer index = RandomFlowUtil.computeIndexById(userId, wechatPutConfigDtos);
            return wechatPutConfigDtos.get(index);
        }
    }
}
