package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.rsp.ContentCommentRsp;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiContentCommentDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiContentStarDto;

/**
 * 内容评论remote
 */
@AdvancedFeignClient
public interface RemoteYoutuiContentCommentService {

    /**
     * 插入评论
     *
     * @param commentDto
     * @return
     */
    public Integer commitComment(YoutuiContentCommentDto commentDto);


    /**
     * 获取内容评论
     *
     * @param commentDto
     * @param start
     * @return
     */
    public ContentCommentRsp countComment(YoutuiContentCommentDto commentDto, Integer start);

    /**
     * 插入或者更新评论
     *
     * @param commentDto
     * @return
     */
    public Integer commitOrUpdateCommentByShare(YoutuiContentCommentDto commentDto);

    /**
     * 插入点赞数据
     *
     * @param contentStarDto
     * @return
     */
    public Integer commitStar(YoutuiContentStarDto contentStarDto);

    /**
     * 获取用户对内容的点赞状态
     *
     * @param starDto
     * @return
     */
    public Integer starStatus(YoutuiContentStarDto starDto);

    /**
     * 获取文章点赞总数
     *
     * @param starDto
     * @return
     */
    public Integer countStar(YoutuiContentStarDto starDto);
}
